//
//  POSCommand.h
//  POSSDK
//
//  Created by duyuzhen on 13-6-26.
//  Copyright (c) 2013 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "PortIO.h"
#import "WIFIPort.h"
#import <UIKit/UIKit.h>

#define JudgeParamRangeIn(v, min, max)	if((v) >= (min) || (v) <= (max))	{error_code = ERR_INVALID_ARGUMENT; goto ExitLine;}
#define JudgeParamRangeOut(v, min, max)	if((v) < (min) || (v) > (max))		{error_code = ERR_INVALID_ARGUMENT; goto ExitLine;}

#define MAX_COMMAND_LENGTH                 (0xff)

//**************************************************************************************************
//Enum:Cut papaer mode
typedef enum CutPaperMode
{
	CutFullImmdediately = 0,	//CutFullImmdediately	= 0,
	CutPartImmedediately,		//CutPartImmedediately,
	CutPartAfterFeed			//CutPartAfterFeed
}CutPaperMode;

//**************************************************************************************************
//Enum:Print mode
typedef enum PrintMode
{
	PrintModeStandard = 0,	//StandardMode = 0,
	PrintModePage			//PageMode
}PrintMode;

//**************************************************************************************************
//Enum:papaer type
typedef enum PaperType
{
	PaperTypeCoutinuous = 0,	//CoutinuousPaper = 0,
	PaperTypeMarked				//MarkedPaper
}PaperType;

//**************************************************************************************************
//Enum:Character Mode
typedef enum CharacterMode
{
	EnglishCharacterMode = 0,	
	ChineseCharacterMode
}CharacterMode;

//**************************************************************************************************
//
typedef struct BarcodeNameID
{
	SInt32		barcode_id;
	NSString	*barcode_name;
}BarcodeNameID;

//**************************************************************************************************
//
typedef struct ImageDataRef
{
	SInt32	image_width;
	SInt32	image_height;
	SInt32	image_row_bytes;
	SInt32	image_data_len;
	UInt8	*data_buf;
}ImageDataRef;

//**************************************************************************************************
//Enum:barcode type of 1D and 2D
typedef enum BarcodeTypeSetting
{
	BarcodeUPC_A = 0,
	BarcodeUPC_E,
	BarcodeJAN13orEAN13,
	BarcodeJAN8orEAN8,
	BarcodeCODE39,
	BarcodeITF,
	BarcodeCODABAR,
	BarcodeCODE93,
	BarcodeCODE128,
	BarcodePDF417 = 0,
	BarcodeQR,
	BarcodeMaxicode,
	BarcodeGS1,
}BarcodeTypeSetting;

static BarcodeNameID	BarcodeNameIDSet[] = 
{
	{BarcodeUPC_A,			@"BarcodeUPC-A"},
	{BarcodeUPC_E,			@"BarcodeUPC-E"},
	{BarcodeJAN13orEAN13,	@"BarcodeJAN13orEAN13"},
	{BarcodeJAN8orEAN8,		@"BarcodeJAN8orEAN8"},
	{BarcodeCODE39,			@"BarcodeCODE39"},
	{BarcodeITF,			@"BarcodeITF"},
	{BarcodeCODABAR,		@"BarcodeCODABAR"},
	{BarcodeCODE93,			@"BarcodeCODE93"},
	{BarcodeCODE128,		@"BarcodeCODE128"},
	{BarcodePDF417,			@"BarcodePDF417"},
	{BarcodeQR,				@"BarcodeQR"},
	{BarcodeMaxicode,		@"BarcodeMaxicode"},
	{BarcodeGS1,			@"BarcodeGS1"},
	{-1, nil},
};

//**************************************************************************************************
//Enum:GS1DataBar type
typedef  enum GS1DataBarType
{
    GS1DataBarOmnidirectional = 1,
    GS1DataBarTruncated,
    GS1DataBarStacked,
    GS1DataBarStackedOmnidirectional,
    GS1DataBarLimited,
    GS1DataBarExpanded,
    GS1DataBarExpandedStacked
    
}GS1DataBarType;

//**************************************************************************************************
//Enum:Character set
typedef enum CharacterSet
{
    CharacterSetUSA = 0,
    CharacterSetFrance,                             
    CharacterSetGermany,                           
    CharacterSetUK,                                 
    CharacterSetDenmark_I,                          
    CharacterSetSweden,                             
    CharacterSetItaly,                              
    CharacterSetSpain_I,                            
    CharacterSetJapan,                              
    CharacterSetNorway,                             
    CharacterSetDenmark_II,                         
    CharacterSetSpain_II,                          
    CharacterSetLatin_America,                      
    CharacterSetKorea                              
 }CharacterSet;

//**************************************************************************************************
//Enum:Code Page
typedef enum CodePage
{
    CodePagePC437               = 0,
    CodePageKatakana            = 1,                             
    CodePagePC850               = 2,                           
    CodePagePC860               = 3,                                 
    CodePagePC863               = 4,                          
    CodePagePC865               = 5,                             
    CodePage851_Greek           = 11,                              
    CodePagePC857               = 13,                            
    CodePage737_Greek           = 14,                              
    CodePage928_Greek           = 15,                             
    CodePageWPC125              = 16,                         
    CodePagePC866               = 17,                          
    CodePagePC852               = 18,                      
    CodePagePC858               = 19,
    CodePageThaiTis42_Thai3     = 20,
    CodePageThaiTis11_Thai5     = 21,
    CodePageThaiTis_Thai2       = 22,
    CodePageThaiKu_Thai1        = 23,
    CodePageThaiTis14_Thai4     = 24,
    CodePageThaiTis18_Thai6     = 26,
    CodePageHebrew1             = 27,
    CodePageHebrew2             = 28,
    CodePageHebrew3             = 29,
    CodePage775_Baltic          = 33,
    CodePage855_Cyrillic        = 34,
    CodePage862_hebrew          = 36,
    CodePage864_Arabic          = 37,
    CodePage869_Greek           = 38,
    CodePageFrasi               = 41,
    CodePage772_Lithuanian      = 43,
    CodePage1250_Latin_2        = 45,
    CodePage1251_Cyrillic       = 46,
    CodePage1253_Greek          = 47,
    CodePage1254_Turkish        = 48,
    CodePage1255_Hebrew         = 49,
    CodePage1256_Arabic         = 50,
    CodePage1257_Baltic         = 51,
    CodePage771                 = 54,
    CodePage774_Lithuanian      = 56,
    CodePage3840_IBM_Russian    = 64,
    CodePage3841_Gost           = 65,
    CodePage3843_Polish         = 66,
    CodePage3844_CS2            = 67,
    CodePage3845_Hungarian      = 68,
    CodePage3846_Turkish        = 69,
    CodePage3847_Brazil_ABNT    = 70,
    CodePage3848_Brazil_ABICOMP = 71,
    CodePage1001                = 72,
    CodePage2001                = 73,
    CodePage3001_Estonian_1     = 74,
    CodePage3002_Estonian_2     = 75,
    CodePage3011_Latvian_1      = 76,
    CodePage3012_Latvian_2      = 77,
    CodePage3021_Bulgarian      = 78,
    CodePage3041_Maitese        = 79,
    CodePage8859                = 80,
    CodePagePersia              = 81,
}CodePage;

//**************************************************************************************************
//Enum:Text Alignment Mode
typedef enum TextAlignment
{
	TextAlignmentLeft = 0,	//LeftJustification = 0, 
	TextAlignmentCenter,	//Centering, 
	TextAlignmentRight		//RightJustification
}TextAlignment;

//**************************************************************************************************
//Enum:Font type
typedef enum FontTypeSetting
{
	FontTypeStandardASCII = 0, 
	FontTypeCompressedASCII, 
	FontTypeUserDefined,
	FontTypeChinese
}FontTypeSetting;

//**************************************************************************************************
//Enum:Font Style
typedef enum FontStyleSetting
{
	FontStyleReverse	          = 0x0001,
	FontStyleBold		          = 0x0002,
	FontStyleUpsideDown           = 0x0004,
	FontStyleUnderlineOneDotThick = 0x0008,
	FontStyleUnderlineTwoDotThick = 0x0010
}FontStyleSetting;

//**************************************************************************************************
//Enum:text rotate
typedef enum RotatePrintSetting
{
	RotatePrintNormal = 0, 
	RotatePrintR90,
	RotatePrint180,
	RotatePrintL90,
}RotatePrintSetting;

//**************************************************************************************************
//Enum:text color print
typedef enum PrintColorSetting
{
	PrintColorNormal = 0,
	PrintColorDouble
}PrintColorSetting;


//**************************************************************************************************
//Enum:text color select int doublePrint mode
typedef enum SelectColorSetting
{
    PrintColorFirst = 0,
    PrintColorSecond
}SelectColorSetting;

//**************************************************************************************************
//Enum:Font User Defined
typedef enum FontUserDefined
{
	FontUserDefinedDisable = 0,
	FontUserDefinedEnable
}FontUserDefined;

//**************************************************************************************************
//Enum:Image Mode
typedef enum ImageMode
{
    NormalMode = 0,
    Double_width, 
    Double_height,
    Quadruple
}ImageMode;

//**************************************************************************************************
//Enum:bitmap Mode
typedef enum BitmapMode
{
	 SingleDensity_8   = 0,
	 DoubleDensity_8,
	 SingleDensity_24,
	 DoubleDensity_24
}BitmapMode;

//**************************************************************************************************
//Enum:Hri Font Position
typedef enum HriFontPosition
{ 
    HRINone = 0,	//NoHri = 0,
    HRIAbove,		//AboveBarcode,
    HRIBelow,		//BelowBarcode ,
    HRIAboveAndBelow	//BothAboveAndBelowBarcode
}HriFontPosition;

//**************************************************************************************************
//Enum:QR language mode
typedef enum QRLanguageMode
{
	LanguageChinese = 0,
	LanguageJapanese 
}QRLanguageMode;

//**************************************************************************************************
//Enum:QR language mode
typedef enum QRTypeMode
{
	OriginalType = 0,
	EnhancedType	
}QRTypeMode;

//**************************************************************************************************
//Enum:Hri for GS1
typedef enum GS1Barcodetype
{ 
    GS1DataBar_Omnidirectional = 1,	
    GS1DataBar_Truncated,		
    GS1DataBar_Stacked,		
	GS1DataBar_StackedOmnidirectional,	
	GS1DataBar_Limited,	
	GS1DataBar_Expanded,	
	GS1DataBar_ExpandedStacked,	
}GS1Barcodetype;

//**************************************************************************************************
//Enum:Hri for GS1
typedef enum HriForGS1
{ 
    DataBarAnd2DHri = 1,	//DataBar and 2D in composite barcode,DataBar only in separate barcode, 
    OnlyDataBarHri,		//DataBar in composite barcode or separate barcode,
    Only2DHri,		//print 2D in composite barcode,no print in separate barcode
    NoHri	//no Hri
}HriForGS1;

//**************************************************************************************************
//Enum Print Direction in page mode
typedef enum PrintDirection
{
    LeftToRight = 0,
    BottomToTop,
    RightToLeft,
    TopToBottom
}PrintDirection;

//**************************************************************************************************
//Enum:Starting Position Mode
typedef enum StartingPositionMode
{
	AbsolutePosition = 0,
	RelativePosition	
}StartingPositionMode;

typedef enum TrackNumber
{
	FirstTrack = 0,
	SecondTrack,
	ThirdTrack,
	AllTracks
}TrackNumber;

typedef enum Tn
{
	T0 = 0,
	T1
}Tn;


@interface POSCommand : NSObject
/***************************************************************************************************
 * function:Set communication module instance for printer
 * Param list:port_io:Instance has been connected to printer 
 * return：Procrssing was successful -- SUCCESS; port_io is not the object of PortIO,0r the object isinvalis -- ERR_INVALID_ARGUMENT
 **************************************************************************************************/
- (SInt32)_systemSetPortIO:(PortIO *)port_io;

/***************************************************************************************************
 * function:Initialize printer,clear data in print buffer and set print mode to the default mode when powered on
 * Param list: None
 * return：Procrssing was success -- SUCCESS
 *          Printer resetting failed -- ERR_SYSTEM_RESET
 **************************************************************************************************/
- (SInt32)_systemReset;

/***************************************************************************************************
 * function:select print mode
* Param list: PrintMode:PrintModeStandard -- enter standard mode ,PrintModePage -- enter page mode
* return：Procrssing was success -- SUCCESS,Invalid parameter was passed -- ERR_INVALID_ARGUMENT,The print mode selecting failed -- ERR_SYSTEM_SELECT_PRINT_MODE
 **************************************************************************************************/
- (SInt32)_systemSelectPrintMode:(SInt32)Mode;

/***************************************************************************************************
 * function:select paper type
 * Param list: PaperType:PaperTypeCoutinuous -- select  continuous paper;PaperTypeMarked-- select  marked paper
 * return： SUCCESS,EERR_INVALID_ARGUMENT,The paper type selecting failed -- ERR_SYSTEM_SELECT_PAPER_TYPE
 **************************************************************************************************/
- (SInt32)_systemSelectPaperType:(SInt32)PaperType;

/***************************************************************************************************
 * function:Set the horizontal and vertical motion units
 * Param list: HorizontalUnit:[0 255];VerticalUnit:[0 255]
  * return： SUCCESS,ERR_INVALID_ARGUMENT, The motion uint selecting failed -- ERR_SYSTEM_SET_MOTION_UNIT
 **************************************************************************************************/
- (SInt32)_systemSetMotionUnit:(SInt32)HorizontalUnit VerticalUnit:(SInt32)VerticalUnit;

/***************************************************************************************************
 * function:Query Status for WIFI
 * Param list: QueryStatusBuffer:The buffer for storing printer's status
 *             ReadSize:The number of bytes which would be read.
 * return： Procrssing was success -- SUCCESS,
 *          The bytes of return are different from Bytes of datas which will be read -- ERR_COMMUNICATE ,
 *          The printer’s status querying failed -- ERR_SYSTEM_QUERY_STATUS
 **************************************************************************************************/
- (SInt32)_systemQueryStatus:(UInt8*)QueryStatusBuffer ReadSize:(SInt32)ReadSize;

/***************************************************************************************************
 * function:Print and line feed
 * Param list: LineNum:the number of feed line ( >= 1)
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Feed line failed -- ERR_SYSTEM_FEED_LINE
 **************************************************************************************************/
- (SInt32)_systemFeedLine:(SInt32)LineNum;

/***************************************************************************************************
 * function: Select cut paper mode and cut paper 
 * Param list: CutMode: CutFullImmdediately -- Full cut; CutPartImmedediately * -- Part cut; CutPartAfterFeed  -- Feed and Part cut
 *             FeedDistance:Feed paper distance[0 255]
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The paper cutting failed -- ERR_SYSTEM_CUT_PAPER
 **************************************************************************************************/
- (SInt32)_systemCutPaper:(SInt32)CutMode FeedDistance:(SInt32)FeedDistance;

/***************************************************************************************************
 * function: Download File
 * Param list: FileName:the file name would be download
 * return： SUCCESS,ERR_COMMUNICATE,ERR_INVALID_ARGUMENT
 **************************************************************************************************/
- (SInt32)_systemDownloadFile:(NSString*)FileName DownloadTimeOut:(SInt32)DownloadTimeOut;

/***************************************************************************************************
 * function: Output the cash drawer control pulse to specified connector pin
 * Param list: CashdrawerID: [0 1], 0 – Pin2; 1 – Pin5; Fee * PulseOnTimes : [0 255]; PulseOffTimes: [0 255]
  * return： SUCCESS,ERR_INVALID_ARGUMENT,The cashdrawer opening failed -- ERR_CASH_DRAWER_OPEN
 **************************************************************************************************/
- (SInt32)_cashdrawerOpen:(SInt32)CashdrawerID PulseOnTimes:(SInt32)PulseOnTimes PulseOffTimes:(SInt32)PulseOffTimes;

/***************************************************************************************************
 * function: Select an international character set
 * Param list: CharSet: CharacterSetUSA /CharacterSetFrance/CharacterSetGermany/CharacterSetUK/CharacterSetDenmark_I/CharacterSetSweden/CharacterSetItaly/CharacterSetSpain_I/CharacterSetJapan/CharacterSetNorway/CharacterSetDenmark_II/CharacterSetSpain_II/CharacterSetLatin_America/ CharacterSetKorea
 * return： SUCCESS,ERR_INVALID_ARGUMENT,
 *          The char set selecting failed -- ERR_TEXT_SELECT_CHAR_SET
 **************************************************************************************************/
- (SInt32)_textSelectCharSet:(SInt32)CharSet;

/***************************************************************************************************
 * function: Set code page
 * Param list: CodePage: CodePagePC437\CodePageKatakana\CodePagePC850\CodePagePC860\CodePagePC863\CodePagePC865\CodePage851_Greek\CodePagePC857\CodePage737_Greek\CodePage928_Greek\ CodePageWPC125\CodePagePC866\CodePagePC852\CodePagePC858\CodePageThaiTis42_Thai3\ CodePageThaiTis11_Thai5\CodePageThaiTis_Thai2\CodePageThaiKu_Thai1\CodePageThaiTis14_Thai4\ CodePageThaiTis18_Thai6\CodePageHebrew1\CodePageHebrew2\CodePageHebrew3\CodePage775_Baltic\ CodePage855_Cyrillic\CodePage862_hebrew\CodePage864_Arabic\CodePage869_Greek\CodePageFrasi\ CodePage772_Lithuanian\CodePage1250_Latin_2\CodePage1251_Cyrillic\CodePage1253_Greek\ CodePage1254_Turkish\CodePage1255_Hebrew\CodePage1256_Arabic\CodePage1257_Baltic\CodePage771\ CodePage774_Lithuanian\CodePage3840_IBM_Russian\CodePage3841_Gost\CodePage3843_Polish\ CodePage3844_CS2\CodePage3845_Hungarian\CodePage3846_Turkish\CodePage3847_Brazil_ABNT\ CodePage3848_Brazil_ABICOMP\CodePage1001\CodePage2001\CodePage3001_Estonian_1\CodePage3002_Estonian_2\CodePage3011_Latvian_1\CodePage3012_Latvian_2\CodePage3021_Bulgarian      \CodePage3041_Maitese\ CodePage8859\CodePagePersia 
 * return： SUCCESS,ERR_INVALID_ARGUMENT,
 *          The code page selecting failed -- ERR_TEXT_SELECT_CODE_PAGE
 **************************************************************************************************/
- (SInt32)_textSelectCodePage:(SInt32)CodePage;

/***************************************************************************************************
 * function: Set line spacing
 * Param list: Height:the line spacing [0 255]
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The line height setting failed -- ERR_TEXT_SET_LINE_HEIGHT
 **************************************************************************************************/
- (SInt32)_textSetLineHeight:(SInt32)Height;

/***************************************************************************************************
 * function: Set character spacing
 * Param list: LeftSpace: the character spacing for the left side of the character to inch [0 255]
 *             RightSpace: the character spacing for the right side of the character to inch [0 255]
 *             Mode:EnglishCharacterMode\ChineseCharacterMode
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The character space setting failed -- ERR_TEXT_SET_CHARACTER_SPACE
 **************************************************************************************************/
- (SInt32)_textSetCharacterSpace:(SInt32)LeftSpace RightSpace:(SInt32)RightSpace Mode:(SInt32)Mode;

/***************************************************************************************************
 * function: Align all the data in one line to the specified position
 * Param list: Alignment: TextAlignmentLeft – Left Justification; TextAlignmentCenter –Centering;
 TextAlignmentRight –Right Justification;
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          The alignment mode selecting failed -- ERR_TEXT_STANDARD_MODE_ALIGNMENT
 **************************************************************************************************/
- (SInt32)_textStandardModeAlignment:(SInt32)Alignment;

/***************************************************************************************************
 * function: Select character font
 * Param list: FontType: FontTypeStandardASCII –Standard ASCII Font selected;
 *                       FontTypeCompressedASCII  –Compressed ASCII font selected;
 *                       FontTypeUserDefined –User-defined character selected;
 *                       FontTypeChinese –Chinese font selected;
 * return： SUCCESS,ERR_INVALID_ARGUMENT,The font type selecting failed -- ERR_TEXT_SELECT_FONT_TYPE
 **************************************************************************************************/
- (SInt32)_textSelectFontType:(SInt32)FontType;

/***************************************************************************************************
 * function: Turn white/black reverse printing mode on/off
 * Param list: Reverse: white/black reverse mode is turned off or on. FontStyleReverse -- white/black reverse mode is turned on; If you input other value,white/black reverse mode is turned off.
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Reverse failed -- ERR_TEXT_SET_FONT_STYLE_REVERSE
 **************************************************************************************************/
- (SInt32)_textStyleReverse:(SInt32)Reverse;

/***************************************************************************************************
 * function: Turn emphasized mode on/off
 * Param list: Bold: emphasized mode is turned off or on, FontStyleBold -- emphasized mode is turned on; If you input other value,emphasized mode is turned off
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Bold failed -- ERR_TEXT_SET_FONT_STYLE_BOLD
 **************************************************************************************************/
- (SInt32)_textStyleBold:(SInt32)Bold;

/***************************************************************************************************
 * function: Turn underline mode on/off
 * Param list: Underline: underline mode is turned off or on . FontStyleUnderlineOneDotThick -– Turn on underline mode (1-dot thick);FontStyleUnderlineTwoDotThick -- Turn on underline mode (2-dots thick),If you input other value,underline mode is turned off
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Underline failed -- ERR_TEXT_SET_FONT_STYLE_UNDERLINE
 **************************************************************************************************/
- (SInt32)_textStyleUnderline:(SInt32)Underline;

/***************************************************************************************************
 * function: Turn on/off upside-down printing mode
 * Param list: UpsideDown: upside-down printing mode is turned off or on .FontStyleUpsideDown -- upside-down printing mode is turned on;If you input other value,upside-down printing mode is turned off
  * return： SUCCESS,ERR_INVALID_ARGUMENT,Upside-down failed -- ERR_TEXT_SET_FONT_STYLE_UPSIDEDOWN
**************************************************************************************************/
- (SInt32)_textStandardModeUpsideDown:(SInt32)UpsideDown;

/***************************************************************************************************
 * function: Select character size
 * Param list: HorizontalTimes:Horizontal number of Times(1-6)
 *             VerticalTimes:Vertical number of Times(1-6)
 * return： SUCCESS,ERR_INVALID_ARGUMENT, 
 *          Magnify times selecting was failed -- ERR_TEXT_SELECT_MAGNIFY_TIMES
**************************************************************************************************/
- (SInt32)_textSelectFontMagnifyTimes:(SInt32)HorizontalTimes VerticalTimes:(SInt32)VerticalTimes;

/***************************************************************************************************
 * function: Rotate integer times 90 degree
 * Param list: Rotate:Rotate degree.RotatePrintNormal --normal; RotatePrintR90 -- clockwise 90;RotatePrint180 -- 180;RotatePrintL90 -- clockwise 270
 * return： SUCCESS,ERR_PROCESSING,
 *          Roration setting failed -- ERR_TEXT_STANDARD_MODE_ROTATE
**************************************************************************************************/
- (SInt32)_textStandardModeRotate:(SInt32)Rotate;

/***************************************************************************************************
 * function: Enter/Exit bi-colour print mode 
 * Param list: ColorPrint: Enter/Exit bi-colour print mode [0 1], 0 Exit bi-colour print mode; 1–Enter bi-colour print mode 
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Failed to enter/quit bi-color printing -- ERR_TEXT_ENTER_QUIT_COLOR_PRINT
**************************************************************************************************/
- (SInt32)_textEnterOrQuitColorPrint:(SInt32)ColorPrint;

/***************************************************************************************************
 * function: Select print colour.   The color two is set  
 * Param list:None
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Color setting failed  -- ERR_TEXT_SET_COLOR_PRINT
**************************************************************************************************/
- (SInt32)_textSetColorPrint:(SInt32)ColorSelect;

/***************************************************************************************************
 * function: User-defined character is enable/disable.
* Param list: Enable: Font User Defined Enable or not, FontUserDefinedDisable -- disable; FontUserDefinedEnable -- enable
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined enable failed -- ERR_TEXT_FONT_USER_DEFINED_ENABLE
**************************************************************************************************/
- (SInt32)_textUserDefinedCharacterEnable:(SInt32)Enable;

/***************************************************************************************************
 * function: Define User-defined character 
 * Param list: BytesOfHeight: Bytes Of Height       3
 *             StartingCharCode:Starting Char Code [32 127]
 *             EndingCharCode:Ending Char Code     [32 127]
 *             DotsOfWidth: Dots Of Width          9 or 12
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined character defining failed -- ERR_TEXT_FONT_USER_DEFINED
**************************************************************************************************/
- (SInt32)_textUserDefinedCharacterDefine:(SInt32)BytesOfHeight DotsOfWidth:(SInt32)DotsOfWidth StartingCode:(SInt32)StartingCode EndingCode:(SInt32)EndingCode CharacterData:(NSData*)CharacterData;

/***************************************************************************************************
 * function: Text Cancel Font User Defined of CharCode
 * Param list: CharCode: the CharCode of CancelCharacter [32 127]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined character canceling failed -- ERR_TEXT_FONT_USER_DEFINED_CANCEL
**************************************************************************************************/
- (SInt32)_textUserDefinedCharacterCancel:(SInt32)CharCode;

/***************************************************************************************************
 * function: Define User Defined  Font for Chinese Character
 * Param list: BytesOfHeight: Bytes Of Height      3
 *             DotsOfWidth: Dots Of Width          24
 *             Code:the seconde code of Chinese character [A1 -FE]
 *             CharacterData:the data of User Defined Chinese Character
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          User-defined Chinese character defining failed -- ERR_TEXT_FONT_USER_DEFINED
**************************************************************************************************/
- (SInt32)_textUserDefinedChineseCharacterDefine:(SInt32)BytesOfHeight DotsOfWidth:(SInt32)DotsOfWidth Code:(SInt32)Code CharacterData:(NSData*)CharacterData;

/***************************************************************************************************
 * function: image print in standard mode 
 * Param list:Mode:Image print mode:SigleDensity_8\DoubleDensity_8\SigleDensity_24\DoubleDensity_24;
 *            Image: the image would be print 
 *            StartHorPos:The parameter can not be used, and it fixed as 0
 * return：SUCCESS,Invalid parameter was passed/Image data was null --ERR_INVALID_ARGUMENT,
 *         Image downloading and printing failed -- ERR_IMAGE_DOWNLOAD_AND_PRINT,
 *         Allocing memory was failed -- ERR_ALLOC_MEMORY
**************************************************************************************************/
- (SInt32)_imageStandardModePrint:(SInt32)Mode Image:(UIImage*)Image StartHorPos:(SInt32)StartHorPos;

/***************************************************************************************************
 * function: Download image to RAM  
 * Param list:Image: the image would be Download ;
 *            ImageID:the ID of download [0-7]
 * return：SUCCESS,Invalid parameter was passed/Image data was null --ERR_INVALID_ARGUMENT,
 *         RAM images downloading failed -- ERR_IMAGE_DOWNLOAD_RAM,
 *         Allocing memory was failed -- ERR_ALLOC_MEMORY,
 *         The image data converted was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)_imageDownloadToPrinterRAM:(UIImage*)Image ImageID:(UInt8)ImageID;

/***************************************************************************************************
 * function: Print image which downloaded to RAM  
 * Param list:ImageID: the image ID has been downloaded to RAM ;
 *            Mode:Print Mode:   NormalMode\Double_width\ Double_height\Quadruple
 * return： SUCCESS,ERR_INVALID_ARGUMENT,RAM image printing failed -- ERR_IMAGE_RAM_PRINT
**************************************************************************************************/
- (SInt32)_imageRAMPrint:(SInt32)ImageID Mode:(SInt32)Mode;

/***************************************************************************************************
 * function: Download image to Flash  
 * Param list:ImageArray: the array of original image would be download to Flash[1-255]
 *            ImageID:the ID of download [0-7]
 * return：SUCCESS,Invalid parameter was passed/Image data was null --ERR_INVALID_ARGUMENT,
 *         Flash images downloading failed -- ERR_IMAGE_DOWNLOAD_Flash,
 *         Allocing memory was failed -- ERR_ALLOC_MEMORY,
 *         The image data converted was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)_imageDownloadToPrinterFlash:(NSMutableArray*)ImageArray;

/***************************************************************************************************
 * function: Print image which downloaded to Flash  
 * Param list:ImageID: the image ID has been downloaded to Flash ;
 *            Mode:Print Mode:   NormalMode\Double_width\ Double_height\Quadruple
 * return： SUCCESS,ERR_INVALID_ARGUMENT,Flash image printing failed -- ERR_IMAGE_FLASH_PRINT
**************************************************************************************************/
- (SInt32)_imageFlashPrint:(SInt32)ImageID Mode:(SInt32)Mode;

/***************************************************************************************************
 * function: Zoom image 
 * Param list:Image: the image would be zoom;
 *            PrinterWidth:the width of print area
 * return： the image processed
**************************************************************************************************/
- (UIImage *)_imageInitWithUIImage:(UIImage*)Image PrinterWidth:(SInt32)PrinterWidth;

/***************************************************************************************************
 * function: Print raster image in standard mode 
 * Param list:image: the image would be print;
 * return：SUCCESS,Invalid parameter was passed/Image data==nil --ERR_INVALID_ARGUMENT,Image raster printing failed -- ERR_IMAGE_STANDARD_MODE_RASTER_PRINT,The data converted into raster image data was null -- ERR_INVALID_DATA
**************************************************************************************************/
- (SInt32)_imageStandardModeRasterPrint:(UIImage*)Image;

/***************************************************************************************************
 * function: Convert image format  
 * Param list:Image:The image would be convert;
 *            ditheringSupported: dithering is Supported or not 
 *            ConvertMode:Mode of convert
 *            ImageData:the image data
 * return： SUCCESS,Allocing memory was failed -- ERR_ALLOC_MEMORY
**************************************************************************************************/
- (SInt32)_imageFormatConvertToUserDefinedData:(UIImage*)Image  ditheringSupported:(BOOL)ditheringSupported image_data:(ImageDataRef*)image_data;

/***************************************************************************************************
 * function: Set print area width in standard mode 
 * Param list: Width:print area width[0 65535].
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Print area width for standard mode setting failed -- ERR_STANDARD_MODE_SET_PRINTAREA_WIDTH
**************************************************************************************************/
- (SInt32)_standardModeSetPrintAreaWidth:(SInt32)Width;

/***************************************************************************************************
 * function: Set Left Margin   
 * Param list: LeftMargin:Left margin[0 65535].
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Left margin for standard mode setting failed -- ERR_STANDARD_MODE_SET_LEFT_MARGIN
**************************************************************************************************/
- (SInt32)_standardModeSetLeftMargin:(SInt32)LeftMargin;

/***************************************************************************************************
 * function: Horizontal Starting Position in standard mode
 * Param list: Mode:AbsolutePosition -- Absolute vertical print position ;RelativePosition -- ralative vertical print position
 *             LeftMargin:Horizontal Starting Position[0 65535].
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Horizontal starting position for standard mode setting failed -- ERR_STANDARD_MODE_SET_HORIZONTAL_STARTING_POSITION
**************************************************************************************************/
- (SInt32)_standardModeSetHorizontalStartingPosition:(SInt32)Mode Distance:(SInt32)Distance;

/***************************************************************************************************
 * function: Vertical Starting Position in page mode
 * Param list: Mode:AbsolutePosition -- Absolute vertical print position ;RelativePosition -- ralative vertical print position
 *             Distance:Vertical Print Position[0 65535].
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Vertical starting position for page mode setting failed -- ERR_PAGE_MODE_SET_VERTICAL_STARTING_POSITION
**************************************************************************************************/
- (SInt32)_pageModeSetVerticalStartingPosition:(SInt32)Mode Distance:(SInt32)Distance;

/***************************************************************************************************
 * function: Set Print Area in page mode
 * Param list: X:Horizontal starting position
 *             Y:Vertical starting position
 *             AreaWidth:Printing Area Width
 *             AreaHeight:Printing AreaHeight
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Print area for page mode setting failed -- ERR_PAGE_MODE_SET_PRINT_AREA
**************************************************************************************************/
- (SInt32)_pageModeSetPrintArea:(SInt32)X Y:(SInt32)Y AreaWidth:(SInt32)AreaWidth AreaHeight:(SInt32)AreaHeight;

/***************************************************************************************************
 * function: Set print direction in page mode
 * Param list: Direction:print direction(LeftToRight\BottomToTop\RightToLeft\LeftToRight)
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Print direction for page mode setting failed -- ERR_PAGE_MODE_SET_PRINT_DIRECTION
**************************************************************************************************/
- (SInt32)_pageModeSetPrintDirection:(SInt32)Direction;

/***************************************************************************************************
 * function: Print data in page mode
 * Param list: none
 * return： SUCCESS
 *          Page mode printing failed -- ERR_PAGE_MODE_PRINT
**************************************************************************************************/
- (SInt32)_pageModePrint;

/***************************************************************************************************
 * function: In page mode,delete all the print data in current area.
 * Param list: none
 * return： SUCCESS
 *          Page mode clearing buffer failed -- ERR_PAGE_CLEAR_BUFFER
**************************************************************************************************/
- (SInt32)_pageModeClearBuffer;

/***************************************************************************************************
 * function: Get barcode ID by comparing name of barcode
 * Param list: BarcodeName:BarcodeUPC-A\BarcodeUPC-E\BarcodeJAN13orEAN13\BarcodeJAN8orEAN8\BarcodeCODE39\
                           BarcodeITF\BarcodeCODABAR\BarcodeCODE93\BarcodeCODE128
 * return：Success -- The ID of specified barcode,Failed -- -1
**************************************************************************************************/
//- (SInt32)_barcodeGetIDByName:(NSString*)BarcodeName;

/***************************************************************************************************
 * function: Get name by  barcode ID 
 * Param list: BarcodeID :0-8
 * return： Success -- The name of specified barcode,Failed -- nil
**************************************************************************************************/
//- (NSString*)_barcodeGetNameByID:(SInt32)BarcodeID;

/***************************************************************************************************
 * function: Print 1Dimension barcode
 * Param list: BarcodeType:	BarcodeUPC_A \BarcodeUPC_E \BarcodeJAN13orEAN13 \ BarcodeJAN8orEAN8\ BarcodeCODE39 \BarcodeITF\BarcodeCODABAR \BarcodeCODE93\BarcodeCODE128
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Barcode type selecting failed -- ERR_BARCODE_PRINT_1D
**************************************************************************************************/
- (SInt32)_barcodePrint1Dimension:(SInt32)BarcodeType DataLength:(SInt32)DataLength;

/***************************************************************************************************
 * function: Print 2Dimension barcode
 * Param list: BarcodeType:		BarcodePDF417 = 0\ BarcodeQR\ BarcodeMaxicode\ BarcodeGS1,
 * return： SUCCESS,ERR_PROCESSING,ERR_INVALID_ARGUMENT
**************************************************************************************************/
- (SInt32)_barcodePrint2Dimension:(SInt32)BarcodeType DataLength:(SInt32)DataLength;

/***************************************************************************************************
 * function: Select barcode module width
 * Param list: ModuleWidth:	barcode module width[2 6]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Module width selecting failed --  ERR_BARCODE_SELECT_MODULE_WIDTH
**************************************************************************************************/
- (SInt32)_barcodeSelectModuleWidth:(SInt32)ModuleWidth;

/***************************************************************************************************
 * function: Set barcode height
 * Param list: BarcodeHeight:	barcode height[1 255]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Barcode height selecting failed -- ERR_BARCODE_SELECT_BARCODE_HEIGHT
**************************************************************************************************/
- (SInt32)_barcodeSelectBarcodeHeight:(SInt32)BarcodeHeight;

/***************************************************************************************************
 * function: Select Hri Font Type
 * Param list: Type:Hri Font Type(FontTypeStandardASCII \ FontTypeCompressedASCII)
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Hri font type selecting failed -- ERR_BARCODE_SELECT_HRI_FONT_TYPE
**************************************************************************************************/
- (SInt32)_barcodeSelectHriFontType:(SInt32)Type;

/***************************************************************************************************
 * function: Select Hri Font position
 * Param list: Position:Hri Font Position:HRINone\HRIAbove\ HRIBelow\ HRIAboveAndBelow
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *          Hri position selecting failed -- ERR_BARCODE_SELECT_HRI_FONT_POSITION
**************************************************************************************************/
- (SInt32)_barcodeSetHriFontPosition:(SInt32)Position;

/***************************************************************************************************
 * function: Print QR
 * Param list: BasicElementWidth: basic element Width[1 10]
 *             SymbolType:SymbolType(OriginalType\EnhancedType)
 *             LanguageMode:Language Mode(LanguageChinese\LanguageJapanese)
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         The parameters of QR setting failed -- ERR_BARCODE_QR_SET_PARAM
**************************************************************************************************/
- (SInt32)_barcodePrintQR:(SInt32)BasicElementWidth LanguageMode:(SInt32)LanguageMode SymbolType:(SInt32)SymbolType;

/***************************************************************************************************
 * function: Select correction grade of barcodePDF417
 * Param list: CorrectionGrade:Correction Grade[0-8]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         PDF417 correction grade selecting failed -- ERR_BARCODE_PDF417_SELECT_CORRECTION_GRADE
**************************************************************************************************/
- (SInt32)_barcodePrintPDF417CorrectionGrade:(SInt32)CorrectionGrade;

/***************************************************************************************************
 * function: set barcodePDF417 size
 * Param list: AppearanceToHeight:Appearance to height[1-10];
 *             AppearanceToWidth:Appearance to width[1-100];
 *             RowNumber:the number of rows[3-90];
 *             ColumnNumber:the number of columns[1-30];
 *             XSize:[1-7];
 *             LineHeight:line height[2-25];
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         PDF417 size setting failed -- ERR_BARCODE_PDF417_SET_SIZE
**************************************************************************************************/
- (SInt32)_barcodePrintPDF417:(SInt32)AppearanceToHeight AppearanceToWidth:(SInt32)AppearanceToWidth RowNumber:(SInt32)RowNumber ColumnNumber:(SInt32)ColumnNumber  XSize:(SInt32)XSize LineHeight:(SInt32)LineHeight;

/***************************************************************************************************
 * function: set GS1DataBar paramter
 * Param list: BarcodeType: GS1DataBarOmnidirectional \ GS1DataBarTruncated\ GS1DataBarStacked\
 *                        GS1DataBarStackedOmnidirectional\ GS1DataBarLimited\ GS1DataBarExpanded\ GS1DataBarExpandedStacked
 *             BasicElementWidth:Basic element width[1-6];
 *             BarcodeHeight:Barcode height[2-250];
 *             BasicElementHeight:Basic element height[1-10];
 *             SeparatorHeight:Separator height[1-10];
 *             SegmentNumber:Segment number[2-20];
 *             HRI:HRI character.DataBarAnd2DHri\OnlyDataBarHri\Only2DHri\NoHri
 *             AI:whether to use AI[0-1]
 * return： SUCCESS,ERR_INVALID_ARGUMENT
 *         Parameters of GS1 setting failed -- ERR_BARCODE_GS1DATABAR_SET_PARAM
**************************************************************************************************/
- (SInt32)_barcodePrintGS1DataBar:(SInt32)BarcodeType BasicElementWidth:(SInt32)BasicElementWidth BarcodeHeight:(SInt32)BarcodeHeight SegmentNumber:(SInt32)SegmentNumber SeparatorHeight:(SInt32)SeparatorHeight BasicElementHeight:(SInt32)BasicElementHeight HRI:(SInt32)HRI UseAI:(SInt32)AI;

///***************************************************************************************************
// * function: Query the status of MSR
// * return： Success -- the status of Msr is ready,Failed -- ERR_MSR_QUERY_STATUS
// **************************************************************************************************/
//- (SInt32)_MsrGetStatus_Old;
//
///***************************************************************************************************
// * function: Cancel swiping card
// * return： Success -- cancel success,Failed -- ERR_MSR_CANCEL_SWIP_CARD
// **************************************************************************************************/
//- (SInt32)_MsrCancelSwipingCard_Old;
//
///***************************************************************************************************
// * function: Read magnetic data for the first track
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)_MsrReadMagneticDataForFirstTrack_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: Read magnetic data for the second track
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)_MsrReadMagneticDataForSecondTrack_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: Read magnetic data for the third track
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)_MsrReadMagneticDataForThirdTrack_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: Read magnetic data for the three tracks
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
// **************************************************************************************************/
//- (NSString*)_MsrReadMagneticDataForThreeTracks_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: IC Initializtion
// * return： Success -- initialization success !,Failed -- ERR_IC_INITIALIZATION
// **************************************************************************************************/
//- (SInt32)_ICInitializtion_Old;
//
///***************************************************************************************************
// * function: Rest IC
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// * return： Success -- open success !,Failed -- open failed !
// **************************************************************************************************/
//- (NSString*)_ICRest_Old:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: T0 protocol
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// *             CommandLength:the length of command
// *             Command:the command to be input
// * return： Success -- success ! and get the received data,Failed -- command runs failed !
// **************************************************************************************************/
//- (NSString*)_ICControlT0_Old:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: T1 protocol
// * Param list: DataBuffer :the receive data buffer
// *             DataSize :the size of data to be received
// *             CommandLength:the length of command
// *             Command:the command to be input
// * return： Success -- success ! and get the received data,Failed -- command runs failed !
// **************************************************************************************************/
//- (NSString*)_ICControlT1_Old:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;
//
///***************************************************************************************************
// * function: IC close
// * return： Success -- close success,Failed -- ERR_IC_CLOSE
// **************************************************************************************************/
//- (SInt32)_ICClose_Old;

/***************************************************************************************************
 * function: Read magnetic data for the first track
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)_MsrReadMagneticDataForFirstTrack:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Read magnetic data for the second track
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)_MsrReadMagneticDataForSecondTrack:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Read magnetic data for the third track
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)_MsrReadMagneticDataForThirdTrack:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Read magnetic data for the three tracks
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- read magnetic success and get the received data,Failed -- read magnetic failed !
 **************************************************************************************************/
- (NSString*)_MsrReadMagneticDataForThreeTracks:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: Rest IC
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 * return： Success -- success ! and get the received data,Failed -- command runs failed !
 **************************************************************************************************/
- (NSString*)_ICRest:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: T0 protocol
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 *             CommandLength:the length of command
 *             Command:the command to be input
 * return： Success -- success ! and get the received data,Failed -- command runs failed !
 **************************************************************************************************/
- (NSString*)_ICControlT0:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

/***************************************************************************************************
 * function: T1 protocol
 * Param list: DataBuffer :the receive data buffer
 *             DataSize :the size of data to be received
 *             CommandLength:the length of command
 *             Command:the command to be input
 * return： Success -- success ! and get the received data,Failed -- command runs failed !
 **************************************************************************************************/
- (NSString*)_ICControlT1:(SInt32)CommandLength Command:(UInt8*)Command DataBuffer:(UInt8*)DataBuffer DataSize:(SInt32)DataSize;

@end
